class Enemy_AlienQueen extends Enemy;

#exec MESH IMPORT MESH=ACQueen ANIVFILE=Models\Enemies\AlienQueen\acqueen_a.3D DATAFILE=Models\Enemies\AlienQueen\acqueen_d.3d X=0 Y=0 Z=0 LODSTYLE=12
#exec MESH ORIGIN MESH=ACQueen X=0 Y=0 Z=-25 YAW=64 ROLL=-255

#exec MESH SEQUENCE MESH=ACQueen SEQ=All		STARTFRAME=1	NUMFRAMES=227
#exec MESH SEQUENCE MESH=ACQueen SEQ=ThreeHit	STARTFRAME=66 NUMFRAMES=10	RATE=15  Group=Attack 
#exec MESH SEQUENCE MESH=ACQueen SEQ=Claw		STARTFRAME=66 NUMFRAMES=10 RATE=17  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Gouge		STARTFRAME=76 NUMFRAMES=10 RATE=17  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Jump		STARTFRAME=96  NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Land		STARTFRAME=97  NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Meditate	STARTFRAME=36 NUMFRAMES=20 RATE=12
#exec MESH SEQUENCE MESH=ACQueen SEQ=OutCold	STARTFRAME=192 NUMFRAMES=20 RATE=15
#exec MESH SEQUENCE MESH=ACQueen SEQ=TakeHit	STARTFRAME=30   NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Run		STARTFRAME=1 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=ACQueen SEQ=Scream		STARTFRAME=152 NUMFRAMES=10 RATE=10
#exec MESH SEQUENCE MESH=ACQueen SEQ=Fighter	STARTFRAME=1  NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Shoot1		STARTFRAME=20 NUMFRAMES=10 RATE=15  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Stab		STARTFRAME=122   NUMFRAMES=10 RATE=8  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Walk		STARTFRAME=1 NUMFRAMES=10 RATE=10
#exec MESH SEQUENCE MESH=ACQueen SEQ=Shield		STARTFRAME=132 NUMFRAMES=10 RATE=8


#exec TEXTURE IMPORT NAME=ACQueen FILE=Textures\Enemies\AlienQueen\ACQueen.bmp GROUP=Skins
#exec MESHMAP SCALE MESHMAP=ACQueen X=0.4 Y=0.4 Z=0.6
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=0 TEXTURE=ACQueen
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=1 TEXTURE=ACQueen
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=2 TEXTURE=ACQueen
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=3 TEXTURE=ACQueen
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=4 TEXTURE=ACQueen
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=5 TEXTURE=ACQueen
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=6 TEXTURE=ACQueen

#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 TIME=0.167 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 TIME=0.255 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 TIME=0.344 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 TIME=0.433 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=OutCold TIME=0.60 FUNCTION=LandThump
#exec MESH NOTIFY MESH=ACQueen SEQ=Claw   TIME=0.5   FUNCTION=ClawDamageTarget
#exec MESH NOTIFY MESH=ACQueen SEQ=Gouge  TIME=0.4   FUNCTION=ClawDamageTarget
#exec MESH NOTIFY MESH=ACQueen SEQ=Stab   TIME=0.33  FUNCTION=StabDamageTarget
#exec MESH NOTIFY MESH=ACQueen SEQ=Walk   TIME=0.26  FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Walk   TIME=0.76  FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Run    TIME=0.25  FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Run    TIME=0.75  FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Shield TIME=0.75  FUNCTION=SpawnShield

#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\claw1Q.WAV" NAME="claw1Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\shoot1Q.WAV" NAME="shoot1Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\yell1Q.WAV" NAME="yell1Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\yell2Q.WAV" NAME="yell2Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\yell3Q.WAV" NAME="yell3Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\stab1Q.WAV" NAME="stab1Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\outcoldQ.WAV" NAME="outcoldQ" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\nearby2Q.WAV" NAME="nearby2Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\amb1Q.WAV" NAME="amb1Q" GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\step1t.WAV" NAME="step1t" GROUP="Titan"
#exec AUDIO IMPORT FILE="Sounds\Enemies\AlienQueen\teleport1.WAV" NAME="Teleport1" GROUP="Generic"

//Queen variables;
var() int ClawDamage,
	StabDamage;
var() name ScreamEvent;

var byte row;
var(Sounds) sound footstepSound;
var(Sounds) sound ScreamSound;
var(Sounds) sound stab;
var(Sounds) sound shoot;
var(Sounds) sound claw;

var bool	bJustScreamed;
var bool	bEndFootStep;
var QueenShield Shield;
var vector TelepDest;

function PostBeginPlay()
{
	Super.PostBeginPlay();
	ProjectileSpeed = 1200 + 100 * Skill;
	GroundSpeed = GroundSpeed * (1 + 0.1 * Skill);
}

event bool EncroachingOn( actor Other )
{
	if ( (Other.Brush != None) || (Brush(Other) != None) )
		return true;
		
	return false;
}

function TryToDuck(vector duckDir, bool bReversed)
{
	if ( (Shield != None) || (AnimSequence == 'Shield') )
		return;

	PlayAnim('Shield', 1.0, 0.1);
	bCrouching = true;
	GotoState('RangedAttack', 'Challenge');
}

function SpawnShield()
{
	Shield = Spawn(class'QueenShield',,,Location + 150 * Vector(Rotation)); 
	Shield.SetBase(self);
}


function ThrowOther(Pawn Other)
{
	local float dist, shake;
	local PlayerPawn aPlayer;
	local vector Momentum;

	if ( Other.mass > 500 )
		return;

	aPlayer = PlayerPawn(Other);				
	if (aPlayer == None)
	{	
		if (Other.Physics != PHYS_Walking)
			return;
		dist = VSize(Location - Other.Location);
		if (dist > 500)
			return;
	}
	else
	{
		dist = VSize(Location - Other.Location);
		shake = FMax(500, 1500 - dist);
		if ( dist > 1500 )
			return;
		aPlayer.ShakeView( FMax(0, 0.35 - dist/20000), shake, 0.015 * shake);
		if ( (Other.Physics != PHYS_Walking) || (dist > 1500) )
			return;
	}
	
	Momentum = -0.5 * Other.Velocity + 100 * Normal(Other.Location - Location);
	Momentum.Z =  7000000.0/((0.5 * dist + 500) * Other.Mass);
	Other.AddVelocity(Momentum);
}

function FootStep()
{
	bEndFootstep = false;
	PlaySound(FootstepSound, SLOT_Interact, 8);
}

function Scream()
{
	local actor A;
	local pawn Thrown;

	if (ScreamEvent != '')
		foreach AllActors( class 'Actor', A, ScreamEvent )
			A.Trigger( Self, Instigator );

	PlaySound(ScreamSound, SLOT_Talk, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlayAnim('Scream');
	bJustScreamed = true;
}

function PlayWaiting()
{
	local float decision;
	local float animspeed;
	
	if (bEndFootStep)
		FootStep();
	decision = FRand();
	animspeed = 0.2 + 0.5 * FRand();
	LoopAnim('Meditate', animspeed);
}

function PlayChallenge()
{
	if (bEndFootStep)
		FootStep();
	if ( IsAnimating() && (AnimSequence == 'Shield') )
		return;
	Scream();
}

function TweenToFighter(float tweentime)
{
	bEndFootStep = ( ((AnimSequence == 'Walk') || (AnimSequence == 'Run')) && (AnimFrame > 0.1) );   
	TweenAnim('Fighter', tweentime);
}

function TweenToRunning(float tweentime)
{
	if ( (AnimSequence != 'Run') || !bAnimLoop )
		TweenAnim('Run', tweentime);
}

function TweenToWalking(float tweentime)
{
	TweenAnim('Walk', tweentime);
}

function TweenToWaiting(float tweentime)
{
	TweenAnim('Meditate', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	TweenAnim('Meditate', tweentime);
}

function PlayRunning()
{
	LoopAnim('Run', -1.0/GroundSpeed,, 0.8);
}

function PlayWalking()
{
	LoopAnim('Walk', -1.0/GroundSpeed,, 0.8);
}

function PlayThreatening()
{
	DesiredSpeed = 0.0;

	if ( FRand() < 0.75)
		PlayAnim('Meditate', 0.4 + 0.6 * FRand(), 0.3);
	else 
	{
		TweenAnim('Fighter', 0.3);
		PlayThreateningSound();
	}
}

function PlayTurning()
{
	if (bEndFootStep)
		FootStep();
	DesiredSpeed = 0.0;
	TweenAnim('Run', 0.4);
}

function PlayDying(name DamageType, vector HitLocation)
{
	PlayAnim('OutCold', 0.7, 0.1);
	PlaySound(Die, SLOT_Talk);	
}

function PlayTakeHit(float tweentime, vector HitLoc, int Damage)
{
	TweenAnim('TakeHit', tweentime);
}

function SpawnShot()
{
	local vector X,Y,Z, projStart;

	GetAxes(Rotation,X,Y,Z);
	
	if (row == 0)
		MakeNoise(1.0);
	
	projStart = Location + 1 * CollisionRadius * X + ( 0.7 - 0.2 * row) * CollisionHeight * Z + 0.2 * CollisionRadius * Y;
	spawn(RangedProjectile ,self,'',projStart,AdjustAim(ProjectileSpeed, projStart, 400 * (4 - row)/(3.5-skill), false, bWarnTarget));

	projStart = Location + 1 * CollisionRadius * X + ( 0.7 - 0.2 * row) * CollisionHeight * Z - 0.2 * CollisionRadius * Y;
	spawn(RangedProjectile ,self,'',projStart,AdjustAim(ProjectileSpeed, projStart, 400 * (4 - row)/(3.5-skill), true, bWarnTarget));
	row++;
}

function PlayVictoryDance()
{
	if (bEndFootStep)
		FootStep();
	DesiredSpeed = 0.0;
	PlayAnim('ThreeHit', 0.7, 0.15); //gib the enemy here!
	PlaySound(Threaten, SLOT_Talk);		
}

function ClawDamageTarget()
{
	if ( MeleeDamageTarget(ClawDamage, (50000.0 * (Normal(Target.Location - Location)))) )
		PlaySound(Claw, SLOT_Interact);
}

function StabDamageTarget()
{
	local vector X,Y,Z;
	GetAxes(Rotation,X,Y,Z);
	
	if ( MeleeDamageTarget(StabDamage, (15000.0 * ( Y + vect(0,0,1)))) )
		PlaySound(Stab, SLOT_Interact);
}

function PlayMeleeAttack()
{
	local float decision;

	if (bEndFootStep)
		FootStep();
	decision = FRand();
	if (decision < 0.4)
	{
		PlaySound(Stab, SLOT_Interact);
 		PlayAnim('Stab');
 	}
	else if (decision < 0.7)
	{
		PlaySound(Claw, SLOT_Interact);
		PlayAnim('Claw');
	} 
	else 
	{
		PlaySound(Claw, SLOT_Interact);
		PlayAnim('Gouge');
	}
}

function TweenToFalling()
{
	TweenAnim('Jump', 0.2);
}

function PlayInAir()
{
	TweenAnim('Jump', 0.5);
}

function PlayLanded(float impactVel)
{
	local Pawn Thrown;

	TweenAnim('Land', 0.1);

	//throw all nearby creatures, and play sound
	Thrown = Level.PawnList;
	While ( Thrown != None )
	{
		ThrowOther(Thrown);
		Thrown = Thrown.nextPawn;
	}
}

function PlayRangedAttack()
{
	if (bEndFootStep)
		FootStep();

	if ( !bJustScreamed && (FRand() < 0.15) )
		Scream();
	else if ( (Shield != None) && (FRand() < 0.5)
		&& (((Enemy.Location - Location) Dot (Shield.Location - Location)) > 0) )
		Scream();
	else
	{
		if ( Shield != None )
			Shield.Destroy();
		row = 0;
		bJustScreamed = false;
		PlayAnim('Shoot1'); 
		PlaySound(Shoot, SLOT_Interact);			
	}
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function PickDestination(bool bNoCharge)
	{
	/* removed to ensure she doesn't teleport but stays and fight
		if ( FRand() < 0.26 )
			GotoState('Teleporting');
		else
	*/
			Super.PickDestination(bNoCharge);
	}
}		
		
state Hunting
{
ignores EnemyNotVisible; 

	function PickDestination()
	{
		//GotoState('Teleporting'); //removed to ensure she doesn't teleport but stays and fight
		Super.PickDestination();
	}
}


State Teleporting
{
ignores TakeDamage, SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, Died;

	function Tick(float DeltaTime)
	{
		local int NewFatness; 
		local rotator EnemyRot;

		if ( Style == STY_Translucent )
		{
			ScaleGlow -= 3 * DeltaTime;
			if ( ScaleGlow < 0.3 )
			{
				Spawn(class'QueenTeleportEffect',,, TelepDest);
				Spawn(class'QueenTeleportLight',,, TelepDest);
				EnemyRot = rotator(Enemy.Location - Location);
				EnemyRot.Pitch = 0;
				SetLocation(TelepDest);
				setRotation(EnemyRot);
				PlaySound(sound'Teleport1', SLOT_Interface);
				GotoState('Attacking');
			}
			return;
		}
		else
		{
			NewFatness = fatness - 100 * DeltaTime;
			if ( NewFatness < 80 )
			{
				bUnlit = true;
				ScaleGlow = 2.0;
				Style = STY_Translucent;
			}
		}

		fatness = Clamp(NewFatness, 0, 255);
	}

	function ChooseDestination()
	{
		local NavigationPoint N;
		local vector ViewPoint, HitLocation, HitNormal, Best;
		local actor HitActor;
		local float rating, newrating;

		N = Level.NavigationPointList;
		Best = Location;
		rating = 0;

		while ( N != None )
		{
			if ( N.IsA('QueenDest') ) // rate it
			{
				newrating = 0;
				if ( Best == Location )
					Best = N.Location;
				ViewPoint = N.Location + EyeHeight * vect(0,0,1);
				HitActor = Trace(HitLocation, HitNormal, Enemy.Location, ViewPoint, false);
				if ( HitActor == None )
					newrating = 20000;

				newrating = newrating - VSize(N.Location - Enemy.Location) + 1000 * FRand()
							+ 4 * VSize(N.Location - Location);
				if ( N.Location.Z > Enemy.Location.Z )
					newrating += 1000;
				
				if ( newrating > rating )
				{
					rating = newrating;
					Best = N.Location;
				}
			}

			N = N.nextNavigationPoint;
		}

		TelepDest = Best;
	}

	function BeginState()
	{
		Acceleration = Vect(0,0,0);
		ChooseDestination();
	}

	function EndState()
	{
		bUnlit = false;
		Style = STY_Normal;
		ScaleGlow = 1.0;
		fatness = Default.fatness;
	}
}

	

defaultproperties
{
    HUDname="Alien"
	HUDcolor=(R=255,G=0,B=0)
    ClawDamage=50
    StabDamage=80
    FootstepSound=Sound'UnrealI.Titan.step1t'
    ScreamSound=Sound'UnrealI.Queen.yell3Q'
    Stab=Sound'UnrealI.Queen.stab1Q'
    Shoot=Sound'UnrealI.Queen.shoot1Q'
    claw=Sound'UnrealI.Queen.claw1Q'
    Aggressiveness=5.00
    RefireRate=0.40
    bHasRangedAttack=True
    bCanDuck=True
    bIsBoss=True
    RangedProjectile=Class'UnrealI.QueenProjectile'
	CarcassType=Class'Carcass_AlienQueen'
    Acquire=Sound'UnrealI.Queen.yell1Q'
    Fear=Sound'UnrealI.Queen.yell2Q'
    Roam=Sound'UnrealI.Queen.nearby2Q'
    Threaten=Sound'UnrealI.Queen.yell2Q'
    MeleeRange=100.00
    GroundSpeed=400.00
    AccelRate=1500.00
    JumpZ=800.00
    Visibility=250
    SightRadius=3000.00
    Health=500
    ReducedDamageType='
    ReducedDamagePct=0.50
    Intelligence=3
    HitSound1=Sound'UnrealI.Queen.yell2Q'
    HitSound2=Sound'UnrealI.Queen.yell2Q'
    Die=Sound'UnrealI.Queen.outcoldQ'
    CombatStyle=0.95
    NameArticle=" the "
    AmbientSound=Sound'UnrealI.Queen.amb1Q'
    DrawType=2
    Mesh=LodMesh'ACQueen'
    SoundRadius=32
    TransientSoundVolume=16.00
    CollisionRadius=90.20
    CollisionHeight=106.70
    Mass=1000.00
    RotationRate=(Pitch=6000,Yaw=50000,Roll=3072)
}
